type
  TVirtualStringTree=class(TCustomVirtualStringTree)
  private
   FDefaultText        :WideString;
   FTextHeight         :Integer;
   FEllipsisWidth      :Integer;
   FInternalDataOffset :Cardinal;
   FOnPaintText        :TVTPaintText;
   FOnGetText          :TVSTGetTextEvent;
   FOnGetHint          :TVSTGetHintEvent;
   FOnNewText          :TVSTNewTextEvent;
   FOnShortenString    :TVSTShortenStringEvent;
   FBorderStyle        :TBorderStyle;
   FHeader             :TVTHeader;
   FRoot               :PVirtualNode;
   FDefaultNodeHeight  :Cardinal;
   FIndent             :Cardinal;
   FOptions            :TCustomVirtualTreeOptions;
   FUpdateCount        :Cardinal;
   FSynchUpdateCount   :Cardinal;
   FNodeDataSize       :Integer;
   FStates             :TVirtualTreeStates;
   FLastSelected       :PVirtualNode;
   FFocusedNode        :PVirtualNode;
   FEditColumn         :TColumnIndex;
   FFocusedColumn      :TColumnIndex;
   FScrollDirections   :TScrollDirections;
   FLastStructureChangeReason:TChangeReason;
   FLastStructureChangeNode:PVirtualNode;
   FLastChangedNode    :PVirtualNode;
   FCurrentHotNode     :PVirtualNode;
   FLastSelRect        :TRect;
   FNewSelRect         :TRect;
   FHotCursor          :TCursor;
   FAnimationType      :THintAnimationType;
   FHintMode           :TVTHintMode;
   FHintData           :TVTHintData;
   FChangeDelay        :Cardinal;
   FEditDelay          :Cardinal;
   FPositionCache      :TCache;
   FVisibleCount       :Cardinal;
   FStartIndex         :Cardinal;
   FSelection          :TNodeArray;
   FSelectionCount     :Integer;
   FRangeAnchor        :PVirtualNode;
   FCheckNode          :PVirtualNode;
   FPendingCheckState  :TCheckState;
   FCheckPropagationCount:Cardinal;
   FLastSelectionLevel :Integer;
   FDrawSelShiftState  :TShiftState;
   FEditLink           :IVTEditLink;
   FTempNodeCache      :TNodeArray;
   FTempNodeCount      :Cardinal;
   FBackground         :TPicture;
   FMargin             :Integer;
   FTextMargin         :Integer;
   FBackgroundOffsetX  :Integer;
   FBackgroundOffsetY  :Integer;
   FAnimationDuration  :Cardinal;
   FWantTabs           :Boolean;
   FNodeAlignment      :TVTNodeAlignment;
   FHeaderRect         :TRect;
   FLastHintRect       :TRect;
   FUpdateRect         :TRect;
   FHintTimeout        :Integer;
   FPlusBM             :TBitmap;
   FMinusBM            :TBitmap;
   FImages             :TCustomImageList;
   FStateImages        :TCustomImageList;
   FCustomCheckImages  :TCustomImageList;
   FCheckImageKind     :TCheckImageKind;
   FCheckImages        :TCustomImageList;
   FImageChangeLink    :TChangeLink;
   FStateChangeLink    :TChangeLink;
   FCustomCheckChangeLink:TChangeLink;
   FOldFontChange      :TNotifyEvent;
   FFontChanged        :Boolean;
   FColors             :TVTColors;
   FButtonStyle        :TVTButtonStyle;
   FButtonFillMode     :TVTButtonFillMode;
   FLineStyle          :TVTLineStyle;
   FLineMode           :TVTLineMode;
   FDottedBrush        :HBRUSH;
   FSelectionCurveRadius:Cardinal;
   FSelectionBlendFactor:Byte;
   FDrawSelectionMode  :TVTDrawSelectionMode;
   FAlignment          :TAlignment;
   FDragImageKind      :TVTDragImageKind;
   FDragOperations     :TDragOperations;
   FDragThreshold      :Integer;
   FDragManager        :IVTDragManager;
   FDropTargetNode     :PVirtualNode;
   FLastDropMode       :TDropMode;
   FDragSelection      :TNodeArray;
   FDragType           :TVTDragType;
   FDragImage          :TVTDragImage;
   FDragWidth          :Integer;
   FDragHeight         :Integer;
   FClipboardFormats   :TClipboardFormats;
   FLastVCLDragTarget  :PVirtualNode;
   FVCLDragEffect      :Integer;
   FScrollBarOptions   :TScrollBarOptions;
   FAutoScrollInterval :TAutoScrollInterval;
   FAutoScrollDelay    :Cardinal;
   FAutoExpandDelay    :Cardinal;
   FOffsetX            :Integer;
   FOffsetY            :Integer;
   FEffectiveOffsetX   :Integer;
   FRangeX             :Cardinal;
   FRangeY             :Cardinal;
   FBottomSpace        :Cardinal;
   FDefaultPasteMode   :TVTNodeAttachMode;
   FSingletonNodeArray :TNodeArray;
   FDragScrollStart    :Cardinal;
   FIncrementalSearch  :TVTIncrementalSearch;
   FSearchTimeout      :Cardinal;
   FSearchBuffer       :WideString;
   FLastSearchNode     :PVirtualNode;
   FSearchDirection    :TVTSearchDirection;
   FSearchStart        :TVTSearchStart;
   FTotalInternalDataSize:Cardinal;
   FPanningWindow      :HWND;
   FPanningCursor      :HICON;
   FPanningImage       :TBitmap;
   FLastClickPos       :TPoint;
   FAccessible         :IAccessible;
   FAccessibleItem     :IAccessible;
   FAccessibleName     :string;
   FOnChange           :TVTChangeEvent;
   FOnStructureChange  :TVTStructureChangeEvent;
   FOnInitChildren     :TVTInitChildrenEvent;
   FOnInitNode         :TVTInitNodeEvent;
   FOnFreeNode         :TVTFreeNodeEvent;
   FOnGetImage         :TVTGetImageEvent;
   FOnGetImageEx       :TVTGetImageExEvent;
   FOnHotChange        :TVTHotNodeChangeEvent;
   FOnExpanding        :TVTChangingEvent;
   FOnCollapsing       :TVTChangingEvent;
   FOnChecking         :TVTCheckChangingEvent;
   FOnExpanded         :TVTChangeEvent;
   FOnCollapsed        :TVTChangeEvent;
   FOnChecked          :TVTChangeEvent;
   FOnResetNode        :TVTChangeEvent;
   FOnNodeMoving       :TVTNodeMovingEvent;
   FOnNodeMoved        :TVTNodeMovedEvent;
   FOnNodeCopying      :TVTNodeCopyingEvent;
   FOnNodeCopied       :TVTNodeCopiedEvent;
   FOnEditing          :TVTEditChangingEvent;
   FOnEditCancelled    :TVTEditCancelEvent;
   FOnBeforeEndEditing :TVTEndEditingEvent;
   FOnAfterEndEditing  :TVTEndEditingEvent;
   FOnEdited           :TVTEditChangeEvent;
   FOnFocusChanging    :TVTFocusChangingEvent;
   FOnFocusChanged     :TVTFocusChangeEvent;
   FOnGetPopupMenu     :TVTPopupEvent;
   FOnPopulatePopopMenu:TNotifyEvent;
   FOnGetHelpContext   :TVTHelpContextEvent;
   FOnCreateEditor     :TVTCreateEditorEvent;
   FOnLoadNode         :TVTSaveNodeEvent;
   FOnSaveNode         :TVTSaveNodeEvent;
   FOnHeaderClick      :TVTHeaderClickEvent;
   FOnHeaderDblClick   :TVTHeaderClickEvent;
   FOnHeaderMouseDown  :TVTHeaderMouseEvent;
   FOnHeaderMouseUp    :TVTHeaderMouseEvent;
   FOnHeaderMouseMove  :TVTHeaderMouseMoveEvent;
   FOnColumnClick      :TVTColumnClickEvent;
   FOnColumnDblClick   :TVTColumnDblClickEvent;
   FOnColumnResize     :TVTHeaderNotifyEvent;
   FOnGetHeaderCursor  :TVTGetHeaderCursorEvent;
   FOnAfterPaint       :TVTPaintEvent;
   FOnBeforePaint      :TVTPaintEvent;
   FOnAfterItemPaint   :TVTAfterItemPaintEvent;
   FOnBeforeItemPaint  :TVTBeforeItemPaintEvent;
   FOnBeforeItemErase  :TVTBeforeItemEraseEvent;
   FOnAfterItemErase   :TVTAfterItemEraseEvent;
   FOnAfterCellPaint   :TVTAfterCellPaintEvent;
   FOnBeforeCellPaint  :TVTBeforeCellPaintEvent;
   FOnHeaderDraw       :TVTHeaderPaintEvent;
   FOnHeaderDrawQueryElements:TVTHeaderPaintQueryElementsEvent;
   FOnAdvancedHeaderDraw:TVTAdvancedHeaderPaintEvent;
   FOnGetLineStyle     :TVTGetLineStyleEvent;
   FOnPaintBackground  :TVTBackgroundPaintEvent;
   FOnMeasureItem      :TVTMeasureItemEvent;
   FOnCreateDragManager:TVTCreateDragManagerEvent;
   FOnCreateDataObject :TVTCreateDataObjectEvent;
   FOnDragAllowed      :TVTDragAllowedEvent;
   FOnDragOver         :TVTDragOverEvent;
   FOnDragDrop         :TVTDragDropEvent;
   FOnHeaderDragged    :TVTHeaderDraggedEvent;
   FOnHeaderDraggedOut :TVTHeaderDraggedOutEvent;
   FOnHeaderDragging   :TVTHeaderDraggingEvent;
   FOnRenderOLEData    :TVTRenderOLEDataEvent;
   FOnGetUserClipboardFormats:TVTGetUserClipboardFormatsEvent;
   FOnGetNodeDataSize  :TVTGetNodeDataSizeEvent;
   FOnKeyAction        :TVTKeyActionEvent;
   FOnScroll           :TVTScrollEvent;
   FOnUpdating         :TVTUpdatingEvent;
   FOnGetCursor        :TVTGetCursorEvent;
   FOnStateChange      :TVTStateChangeEvent;
   FOnGetCellIsEmpty   :TVTGetCellIsEmptyEvent;
   FOnShowScrollbar    :TVTScrollbarShowEvent;
   FOnCompareNodes     :TVTCompareEvent;
   FOnIncrementalSearch:TVTIncrementalSearchEvent;
   FCanvas             :TCanvas;
   FAlignControlList   :TList;
   FAlignLevel         :Word;
   FBevelEdges         :TBevelEdges;
   FBevelInner         :TBevelCut;
   FBevelOuter         :TBevelCut;
   FBevelKind          :TBevelKind;
   FBevelWidth         :TBevelWidth;
   FBorderWidth        :TBorderWidth;
   FPadding            :TPadding;
   FBrush              :TBrush;
   FDockClients        :TList;
   FDockManager        :IDockManager;
   FImeMode            :TImeMode;
   FImeName            :TImeName;
   FParentWindow       :HWND;
   FTabList            :TList;
   FTipMode            :TTipMode;
   FControls           :TList;
   FWinControls        :TList;
   FTabOrder           :Integer;
   FTabStop            :Boolean;
   FTIPIntf            :IInterface;
   FCtl3D              :Boolean;
   FShowing            :Boolean;
   FUseDockManager     :Boolean;
   FDockSite           :Boolean;
   FParentCtl3D        :Boolean;
   FParentDoubleBuffered:Boolean;
   FPerformingShowingChanged:Boolean;
   FOnDockDrop         :TDockDropEvent;
   FOnDockOver         :TDockOverEvent;
   FOnEnter            :TNotifyEvent;
   FOnExit             :TNotifyEvent;
   FOnGetSiteInfo      :TGetSiteInfoEvent;
   FOnKeyDown          :TKeyEvent;
   FOnKeyPress         :TKeyPressEvent;
   FOnKeyUp            :TKeyEvent;
   FOnUnDock           :TUnDockEvent;
   FOnAlignInsertBefore:TAlignInsertBeforeEvent;
   FOnAlignPosition    :TAlignPositionEvent;
   FMouseInClient      :Boolean;
   FMouseControl       :TControl;
   FTouchControl       :TControl;
   FDefWndProc         :Pointer;
   FHandle             :HWND;
   FObjectInstance     :Pointer;
   FParent             :TWinControl;
   FWindowProc         :TWndMethod;
   FLeft               :Integer;
   FTop                :Integer;
   FWidth              :Integer;
   FHeight             :Integer;
   FControlStyle       :TControlStyle;
   FControlState       :TControlState;
   FDesktopFont        :Boolean;
   FVisible            :Boolean;
   FEnabled            :Boolean;
   FParentFont         :Boolean;
   FParentColor        :Boolean;
   FAlign              :TAlign;
   FAutoSize           :Boolean;
   FDragMode           :TDragMode;
   FIsControl          :Boolean;
   FBiDiMode           :TBiDiMode;
   FParentBiDiMode     :Boolean;
   FAnchors            :TAnchors;
   FFont               :TFont;
   FActionLink         :TControlActionLink;
   FColor              :TColor;
   FConstraints        :TSizeConstraints;
   FMargins            :TMargins;
   FCursor             :TCursor;
   FDragCursor         :TCursor;
   FPopupMenu          :TPopupMenu;
   FHint               :string;
   FFontHeight         :Integer;
   FScalingFlags       :TScalingFlags;
   FShowHint           :Boolean;
   FParentShowHint     :Boolean;
   FDragKind           :TDragKind;
   FDockOrientation    :TDockOrientation;
   FHostDockSite       :TWinControl;
   FWheelAccumulator   :Integer;
   FUndockWidth        :Integer;
   FUndockHeight       :Integer;
   FLRDockWidth        :Integer;
   FTBDockHeight       :Integer;
   FFloatingDockSiteClass:TWinControlClass;
   FTouchManager       :TTouchManager;
   FOnCanResize        :TCanResizeEvent;
   FOnConstrainedResize:TConstrainedResizeEvent;
   FOnMouseDown        :TMouseEvent;
   FOnMouseMove        :TMouseMoveEvent;
   FOnMouseUp          :TMouseEvent;
   FOnDragDrop         :TDragDropEvent;
   FOnDragOver         :TDragOverEvent;
   FOnResize           :TNotifyEvent;
   FOnStartDock        :TStartDockEvent;
   FOnEndDock          :TEndDragEvent;
   FOnStartDrag        :TStartDragEvent;
   FOnEndDrag          :TEndDragEvent;
   FOnClick            :TNotifyEvent;
   FOnDblClick         :TNotifyEvent;
   FOnContextPopup     :TContextPopupEvent;
   FOnMouseActivate    :TMouseActivateEvent;
   FOnMouseLeave       :TNotifyEvent;
   FOnMouseEnter       :TNotifyEvent;
   FOnMouseWheel       :TMouseWheelEvent;
   FOnMouseWheelDown   :TMouseWheelUpDownEvent;
   FOnMouseWheelUp     :TMouseWheelUpDownEvent;
   FOnGesture          :TGestureEvent;
   FHelpType           :THelpType;
   FHelpKeyword        :string;
   FHelpContext        :THelpContext;
   FCustomHint         :TCustomHint;
   FParentCustomHint   :Boolean;
   FText               :PWideChar;
   FStyleElements      :TStyleElements;
   FOwner              :TComponent;
   FName               :TComponentName;
   FTag                :NativeInt;
   FComponents         :TList<System.Classes.TComponent>;
   FFreeNotifies       :TList<System.Classes.TComponent>;
   FDesignInfo         :Integer;
   FComponentState     :TComponentState;
   FVCLComObject       :Pointer;
   FObservers          :TObservers;
   FSortedComponents   :TList<System.Classes.TComponent>;
   function GetText(Node: PVirtualNode; Column: TColumnIndex): WideString;
   procedure SetText(Node: PVirtualNode; Column: TColumnIndex; const Value: WideString);
   function GetCheckState(Node: PVirtualNode): TCheckState;
   procedure SetCheckState(Node: PVirtualNode; Value: TCheckState);
   function GetCheckType(Node: PVirtualNode): TCheckType;
   procedure SetCheckType(Node: PVirtualNode; Value: TCheckType);
   function GetChildCount(Node: PVirtualNode): Cardinal;
   procedure SetChildCount(Node: PVirtualNode; NewChildCount: Cardinal);
   function GetChildrenInitialized(Node: PVirtualNode): Boolean;
   function GetExpanded(Node: PVirtualNode): Boolean;
   procedure SetExpanded(Node: PVirtualNode; Value: Boolean);
   function GetFullyVisible(Node: PVirtualNode): Boolean;
   procedure SetFullyVisible(Node: PVirtualNode; Value: Boolean);
   function GetHasChildren(Node: PVirtualNode): Boolean;
   procedure SetHasChildren(Node: PVirtualNode; Value: Boolean);
   function GetDisabled(Node: PVirtualNode): Boolean;
   procedure SetDisabled(Node: PVirtualNode; Value: Boolean);
   function GetVisible(Node: PVirtualNode): Boolean;
   procedure SetVisible(Node: PVirtualNode; Value: Boolean);
   function GetMultiline(Node: PVirtualNode): Boolean;
   procedure SetMultiline(Node: PVirtualNode; const Value: Boolean);
   function GetNodeHeight(Node: PVirtualNode): Cardinal;
   procedure SetNodeHeight(Node: PVirtualNode; Value: Cardinal);
   function GetNodeParent(Node: PVirtualNode): PVirtualNode;
   procedure SetNodeParent(Node: PVirtualNode; const Value: PVirtualNode);
   function GetSelected(Node: PVirtualNode): Boolean;
   procedure SetSelected(Node: PVirtualNode; Value: Boolean);
   function GetVerticalAlignment(Node: PVirtualNode): Byte;
   procedure SetVerticalAlignment(Node: PVirtualNode; Value: Byte);
   function GetVisiblePath(Node: PVirtualNode): Boolean;
   procedure SetVisiblePath(Node: PVirtualNode; Value: Boolean);
   function GetDockClients(Index: Integer): TControl;
   function GetControl(Index: Integer): TControl;
   function GetComponent(AIndex: Integer): TComponent;
  protected
   FDoubleBuffered     :Boolean;
   FInImeComposition   :Boolean;
   FDesignSize         :TPoint;
   FAnchorMove         :Boolean;
   FAnchorRules        :TPoint;
   FAnchorOrigin       :TPoint;
   FOriginalParentSize :TPoint;
   FExplicitLeft       :Integer;
   FExplicitTop        :Integer;
   FExplicitWidth      :Integer;
   FExplicitHeight     :Integer;
   FReserved           :Pointer;
   FComponentStyle     :TComponentStyle;
  public
   constructor Create(AOwner: TComponent);
   function ComputeNodeHeight(Canvas: TCanvas; Node: PVirtualNode; Column: TColumnIndex; S: WideString): Integer;
   function ContentToClipboard(Format: Word; Source: TVSTTextSourceType): NativeUInt;
   function ContentToHTML(Source: TVSTTextSourceType; Caption: WideString): AnsiString;
   function ContentToRTF(Source: TVSTTextSourceType): AnsiString;
   function ContentToText(Source: TVSTTextSourceType; Separator: AnsiChar): AnsiString;
   function ContentToUnicode(Source: TVSTTextSourceType; Separator: Char): WideString;
   procedure GetTextInfo(Node: PVirtualNode; Column: TColumnIndex; const AFont: TFont; var R: TRect; var Text: WideString);
   function InvalidateNode(Node: PVirtualNode): TRect;
   function Path(Node: PVirtualNode; Column: TColumnIndex; TextType: TVSTTextType; Delimiter: Char): WideString;
   procedure ReinitNode(Node: PVirtualNode; Recursive: Boolean);
   procedure ResetNodeWidths(Node: PVirtualNode; Recursive: Boolean);
   constructor Create(AOwner: TComponent);
   class destructor Destroy;
   function AbsoluteIndex(Node: PVirtualNode): Cardinal;
   function AddChild(Parent: PVirtualNode; UserData: Pointer): PVirtualNode;
   procedure AddFromStream(Stream: TStream; TargetNode: PVirtualNode);
   procedure AfterConstruction;
   procedure Assign(Source: TPersistent);
   procedure BeginDrag(Immediate: Boolean; Threshold: Integer);
   procedure BeginSynch;
   procedure BeginUpdate;
   procedure CancelCutOrCopy;
   function CancelEditNode: Boolean;
   function CanFocus: Boolean;
   procedure Clear;
   procedure ClearChecked;
   procedure ClearSelection;
   function CopyTo(Source: PVirtualNode; Tree: TBaseVirtualTree; Mode: TVTNodeAttachMode; ChildrenOnly: Boolean): PVirtualNode;
   function CopyTo(Source: PVirtualNode; Target: PVirtualNode; Mode: TVTNodeAttachMode; ChildrenOnly: Boolean): PVirtualNode;
   procedure CopyToClipBoard;
   procedure CutToClipBoard;
   procedure DeleteChildren(Node: PVirtualNode; ResetHasChildren: Boolean);
   procedure DeleteNode(Node: PVirtualNode; Reindex: Boolean);
   procedure DeleteSelectedNodes;
   function Dragging: Boolean;
   function EditNode(Node: PVirtualNode; Column: TColumnIndex): Boolean;
   function EndEditNode: Boolean;
   procedure EndSynch;
   procedure EndUpdate;
   function ExecuteAction(Action: TBasicAction): Boolean;
   procedure FinishCutOrCopy;
   procedure FlushClipboard;
   procedure FullCollapse(Node: PVirtualNode);
   procedure FullExpand(Node: PVirtualNode);
   function GetControlsAlignment: TAlignment;
   function GetDisplayRect(Node: PVirtualNode; Column: TColumnIndex; TextOnly: Boolean; Unclipped: Boolean): TRect;
   function GetFirst: PVirtualNode;
   function GetFirstChecked(State: TCheckState): PVirtualNode;
   function GetFirstChild(Node: PVirtualNode): PVirtualNode;
   function GetFirstCutCopy: PVirtualNode;
   function GetFirstInitialized: PVirtualNode;
   function GetFirstNoInit: PVirtualNode;
   function GetFirstSelected: PVirtualNode;
   function GetFirstVisible: PVirtualNode;
   function GetFirstVisibleChild(Node: PVirtualNode): PVirtualNode;
   function GetFirstVisibleChildNoInit(Node: PVirtualNode): PVirtualNode;
   function GetFirstVisibleNoInit: PVirtualNode;
   procedure GetHitTestInfoAt(X: Integer; Y: Integer; Relative: Boolean; var HitInfo: THitInfo);
   function GetLast(Node: PVirtualNode): PVirtualNode;
   function GetLastInitialized(Node: PVirtualNode): PVirtualNode;
   function GetLastNoInit(Node: PVirtualNode): PVirtualNode;
   function GetLastChild(Node: PVirtualNode): PVirtualNode;
   function GetLastChildNoInit(Node: PVirtualNode): PVirtualNode;
   function GetLastVisible(Node: PVirtualNode): PVirtualNode;
   function GetLastVisibleChild(Node: PVirtualNode): PVirtualNode;
   function GetLastVisibleChildNoInit(Node: PVirtualNode): PVirtualNode;
   function GetLastVisibleNoInit(Node: PVirtualNode): PVirtualNode;
   function GetMaxColumnWidth(Column: TColumnIndex): Integer;
   function GetNext(Node: PVirtualNode): PVirtualNode;
   function GetNextChecked(Node: PVirtualNode; State: TCheckState): PVirtualNode;
   function GetNextCutCopy(Node: PVirtualNode): PVirtualNode;
   function GetNextInitialized(Node: PVirtualNode): PVirtualNode;
   function GetNextNoInit(Node: PVirtualNode): PVirtualNode;
   function GetNextSelected(Node: PVirtualNode): PVirtualNode;
   function GetNextSibling(Node: PVirtualNode): PVirtualNode;
   function GetNextVisible(Node: PVirtualNode): PVirtualNode;
   function GetNextVisibleNoInit(Node: PVirtualNode): PVirtualNode;
   function GetNextVisibleSibling(Node: PVirtualNode): PVirtualNode;
   function GetNextVisibleSiblingNoInit(Node: PVirtualNode): PVirtualNode;
   function GetNodeAt(X: Integer; Y: Integer): PVirtualNode;
   function GetNodeAt(X: Integer; Y: Integer; Relative: Boolean; var NodeTop: Integer): PVirtualNode;
   function GetNodeData(Node: PVirtualNode): Pointer;
   function GetNodeLevel(Node: PVirtualNode): Cardinal;
   function GetPrevious(Node: PVirtualNode): PVirtualNode;
   function GetPreviousInitialized(Node: PVirtualNode): PVirtualNode;
   function GetPreviousNoInit(Node: PVirtualNode): PVirtualNode;
   function GetPreviousSibling(Node: PVirtualNode): PVirtualNode;
   function GetPreviousVisible(Node: PVirtualNode): PVirtualNode;
   function GetPreviousVisibleNoInit(Node: PVirtualNode): PVirtualNode;
   function GetPreviousVisibleSibling(Node: PVirtualNode): PVirtualNode;
   function GetPreviousVisibleSiblingNoInit(Node: PVirtualNode): PVirtualNode;
   function GetSortedCutCopySet(Resolve: Boolean): TNodeArray;
   function GetSortedSelection(Resolve: Boolean): TNodeArray;
   procedure GetTextInfo(Node: PVirtualNode; Column: TColumnIndex; const AFont: TFont; var R: TRect; var Text: WideString);
   function GetTreeRect: TRect;
   function GetVisibleParent(Node: PVirtualNode): PVirtualNode;
   function HasAsParent(Node: PVirtualNode; PotentialParent: PVirtualNode): Boolean;
   function InsertNode(Node: PVirtualNode; Mode: TVTNodeAttachMode; UserData: Pointer): PVirtualNode;
   procedure InvalidateChildren(Node: PVirtualNode; Recursive: Boolean);
   procedure InvalidateColumn(Column: TColumnIndex);
   function InvalidateNode(Node: PVirtualNode): TRect;
   procedure InvalidateToBottom(Node: PVirtualNode);
   procedure InvertSelection(VisibleOnly: Boolean);
   function IsEditing: Boolean;
   function IsMouseSelecting: Boolean;
   function IterateSubtree(Node: PVirtualNode; Callback: TVTGetNodeProc = procedure(Sender: TBaseVirtualTree; Node: PVirtualNode; Data: Pointer; var Abort: Boolean) of object; Data: Pointer; Filter: TVirtualNodeStates; DoInit: Boolean; ChildNodesOnly: Boolean): PVirtualNode;
   procedure LoadFromFile(const FileName: TFileName);
   procedure LoadFromStream(Stream: TStream);
   procedure MeasureItemHeight(const Canvas: TCanvas; Node: PVirtualNode);
   procedure MoveTo(Source: PVirtualNode; Target: PVirtualNode; Mode: TVTNodeAttachMode; ChildrenOnly: Boolean);
   procedure MoveTo(Node: PVirtualNode; Tree: TBaseVirtualTree; Mode: TVTNodeAttachMode; ChildrenOnly: Boolean);
   procedure PaintTree(TargetCanvas: TCanvas; Window: TRect; Target: TPoint; PaintOptions: TVTInternalPaintOptions; PixelFormat: TPixelFormat);
   function PasteFromClipboard: Boolean;
   procedure PrepareDragImage(HotSpot: TPoint; const DataObject: IDataObject);
   procedure Print(Printer: TPrinter; PrintHeader: Boolean);
   function ProcessDrop(DataObject: IDataObject; TargetNode: PVirtualNode; var Effect: Integer; Mode: TVTNodeAttachMode): Boolean;
   function ProcessOLEData(Source: TBaseVirtualTree; DataObject: IDataObject; TargetNode: PVirtualNode; Mode: TVTNodeAttachMode; Optimized: Boolean): Boolean;
   procedure RepaintNode(Node: PVirtualNode);
   procedure ReinitChildren(Node: PVirtualNode; Recursive: Boolean);
   procedure ReinitNode(Node: PVirtualNode; Recursive: Boolean);
   procedure ResetNode(Node: PVirtualNode);
   procedure SaveToFile(const FileName: TFileName);
   procedure SaveToStream(Stream: TStream; Node: PVirtualNode);
   function ScrollIntoView(Node: PVirtualNode; Center: Boolean; Horizontally: Boolean): Boolean;
   procedure SelectAll(VisibleOnly: Boolean);
   procedure Sort(Node: PVirtualNode; Column: TColumnIndex; Direction: TSortDirection; DoInit: Boolean);
   procedure SortTree(Column: TColumnIndex; Direction: TSortDirection; DoInit: Boolean);
   procedure ToggleNode(Node: PVirtualNode);
   function UpdateAction(Action: TBasicAction): Boolean;
   procedure UpdateHorizontalScrollBar(DoRepaint: Boolean);
   procedure UpdateScrollBars(DoRepaint: Boolean);
   procedure UpdateVerticalScrollBar(DoRepaint: Boolean);
   function UseRightToLeftReading: Boolean;
   procedure ValidateChildren(Node: PVirtualNode; Recursive: Boolean);
   procedure ValidateNode(Node: PVirtualNode; Recursive: Boolean);
   constructor Create(AOwner: TComponent);
   class destructor Destroy;
   constructor Create(AOwner: TComponent);
   constructor CreateParented(ParentWindow: HWND);
   class function CreateParentedControl(ParentWindow: HWND): TWinControl;
   class destructor Destroy;
   procedure Broadcast(var Message);
   function CanFocus: Boolean;
   function ContainsControl(Control: TControl): Boolean;
   function ControlAtPos(const Pos: TPoint; AllowDisabled: Boolean; AllowWinControls: Boolean; AllLevels: Boolean): TControl;
   procedure DefaultHandler(var Message);
   procedure DisableAlign;
   procedure DockDrop(Source: TDragDockObject; X: Integer; Y: Integer);
   procedure EnableAlign;
   function FindChildControl(const ControlName: string): TControl;
   procedure FlipChildren(AllLevels: Boolean);
   function Focused: Boolean;
   procedure GetChildren(Proc: TGetChildProc = procedure(Child: TComponent) of object; Root: TComponent);
   procedure GetTabControlList(List: TList);
   procedure GetTabOrderList(List: TList);
   function HandleAllocated: Boolean;
   procedure HandleNeeded;
   procedure InsertControl(AControl: TControl);
   procedure Invalidate;
   procedure PaintTo(DC: HDC; X: Integer; Y: Integer);
   procedure PaintTo(Canvas: TCanvas; X: Integer; Y: Integer);
   function PreProcessMessage(var Msg: tagMSG): Boolean;
   procedure RemoveControl(AControl: TControl);
   procedure Realign;
   procedure Repaint;
   procedure ScaleBy(M: Integer; D: Integer);
   procedure ScrollBy(DeltaX: Integer; DeltaY: Integer);
   procedure SetBounds(ALeft: Integer; ATop: Integer; AWidth: Integer; AHeight: Integer);
   procedure SetDesignVisible(Value: Boolean);
   procedure SetFocus;
   procedure Update;
   procedure UpdateControlState;
   constructor Create(AOwner: TComponent);
   class destructor Destroy;
   procedure BeginDrag(Immediate: Boolean; Threshold: Integer);
   procedure BringToFront;
   function ClientToScreen(const Point: TPoint): TPoint;
   function ClientToParent(const Point: TPoint; AParent: TWinControl): TPoint;
   procedure Dock(NewDockSite: TWinControl; ARect: TRect);
   function Dragging: Boolean;
   procedure DragDrop(Source: TObject; X: Integer; Y: Integer);
   function DrawTextBiDiModeFlags(Flags: Integer): Integer;
   function DrawTextBiDiModeFlagsReadingOnly: Integer;
   procedure EndDrag(Drop: Boolean);
   function GetControlsAlignment: TAlignment;
   function GetParentComponent: TComponent;
   function HasParent: Boolean;
   procedure Hide;
   procedure InitiateAction;
   procedure Invalidate;
   procedure MouseWheelHandler(var Message: TMessage);
   function IsRightToLeft: Boolean;
   function ManualDock(NewDockSite: TWinControl; DropControl: TControl; ControlSide: TAlign): Boolean;
   function ManualFloat(ScreenPos: TRect): Boolean;
   function Perform(Msg: Cardinal; WParam: NativeUInt; LParam: NativeInt): NativeInt;
   procedure Refresh;
   procedure Repaint;
   function ReplaceDockedControl(Control: TControl; NewDockSite: TWinControl; DropControl: TControl; ControlSide: TAlign): Boolean;
   function ScreenToClient(const Point: TPoint): TPoint;
   function ParentToClient(const Point: TPoint; AParent: TWinControl): TPoint;
   procedure SendToBack;
   procedure SetBounds(ALeft: Integer; ATop: Integer; AWidth: Integer; AHeight: Integer);
   procedure SetDesignVisible(Value: Boolean);
   procedure SetParentComponent(Value: TComponent);
   procedure Show;
   procedure Update;
   function UseRightToLeftAlignment: Boolean;
   function UseRightToLeftReading: Boolean;
   function UseRightToLeftScrollBar: Boolean;
   procedure DefaultHandler(var Message);
   function GetTextBuf(Buffer: PWideChar; BufSize: Integer): Integer;
   function GetTextLen: Integer;
   function Perform(Msg: Cardinal; WParam: NativeUInt; LParam: PWideChar): NativeInt;
   function Perform(Msg: Cardinal; WParam: NativeUInt; var LParam: TRect): NativeInt;
   procedure SetTextBuf(Buffer: PWideChar);
   constructor Create(AOwner: TComponent);
   class destructor Destroy;
   procedure BeforeDestruction;
   procedure DestroyComponents;
   procedure Destroying;
   function ExecuteAction(Action: TBasicAction): Boolean;
   function FindComponent(const AName: string): TComponent;
   procedure FreeNotification(AComponent: TComponent);
   procedure RemoveFreeNotification(AComponent: TComponent);
   procedure FreeOnRelease;
   function GetEnumerator: TComponentEnumerator;
   function GetParentComponent: TComponent;
   function GetNamePath: string;
   function HasParent: Boolean;
   procedure InsertComponent(const AComponent: TComponent);
   procedure RemoveComponent(const AComponent: TComponent);
   procedure SetSubComponent(IsSubComponent: Boolean);
   function SafeCallException(ExceptObject: TObject; ExceptAddr: Pointer): HRESULT;
   function UpdateAction(Action: TBasicAction): Boolean;
   function IsImplementorOf(const I: IInterface): Boolean;
   function ReferenceInterface(const I: IInterface; Operation: TOperation): Boolean;
   class destructor Destroy;
   procedure Assign(Source: TPersistent);
   function GetNamePath: string;
   constructor Create;
   procedure Free;
   procedure DisposeOf;
   class function InitInstance(Instance: Pointer): TObject;
   procedure CleanupInstance;
   function ClassType: TClass;
   class function ClassName: string;
   class function ClassNameIs(const Name: string): Boolean;
   class function ClassParent: TClass;
   class function ClassInfo: Pointer;
   class function InstanceSize: Integer;
   class function InheritsFrom(AClass: TClass): Boolean;
   class function MethodAddress(const Name: ShortString): Pointer;
   class function MethodAddress(const Name: string): Pointer;
   class function MethodName(Address: Pointer): string;
   class function QualifiedClassName: string;
   function FieldAddress(const Name: ShortString): Pointer;
   function FieldAddress(const Name: string): Pointer;
   function GetInterface(const IID: TGUID; out Obj): Boolean;
   class function GetInterfaceEntry(const IID: TGUID): PInterfaceEntry;
   class function GetInterfaceTable: PInterfaceTable;
   class function UnitName: string;
   class function UnitScope: string;
   function Equals(Obj: TObject): Boolean;
   function GetHashCode: Integer;
   function ToString: string;
   function SafeCallException(ExceptObject: TObject; ExceptAddr: Pointer): HRESULT;
   procedure AfterConstruction;
   procedure BeforeDestruction;
   procedure Dispatch(var Message);
   procedure DefaultHandler(var Message);
   class function NewInstance: TObject;
   procedure FreeInstance;
   class destructor Destroy;
   property Canvas: TCanvas;
   property Accessible: IAccessible;
   property AccessibleItem: IAccessible;
   property AccessibleName: string;
   property CheckImages: TCustomImageList;
   property DragImage: TVTDragImage;
   property DragManager: IVTDragManager;
   property DropTargetNode: PVirtualNode;
   property EditLink: IVTEditLink;
   property FocusedColumn: TColumnIndex;
   property FocusedNode: PVirtualNode;
   property Font: TFont;
   property HotNode: PVirtualNode;
   property OffsetX: Integer;
   property OffsetXY: TPoint;
   property OffsetY: Integer;
   property RootNode: PVirtualNode;
   property SearchBuffer: WideString;
   property TotalCount: Cardinal;
   property TreeStates: TVirtualTreeStates;
   property SelectedCount: Integer;
   property TopNode: PVirtualNode;
   property VisibleCount: Cardinal;
   property UpdateCount: Cardinal;
   property DockClientCount: Integer;
   property DockSite: Boolean;
   property DockManager: IDockManager;
   property DoubleBuffered: Boolean;
   property AlignDisabled: Boolean;
   property MouseInClient: Boolean;
   property VisibleDockClientCount: Integer;
   property Brush: TBrush;
   property ControlCount: Integer;
   property Handle: HWND;
   property Padding: TPadding;
   property ParentDoubleBuffered: Boolean;
   property ParentWindow: HWND;
   property Showing: Boolean;
   property TabOrder: TTabOrder;
   property TabStop: Boolean;
   property UseDockManager: Boolean;
   property Enabled: Boolean;
   property Action: TBasicAction;
   property Align: TAlign;
   property Anchors: TAnchors;
   property BiDiMode: TBiDiMode;
   property BoundsRect: TRect;
   property ClientHeight: Integer;
   property ClientOrigin: TPoint;
   property ClientRect: TRect;
   property ClientWidth: Integer;
   property Constraints: TSizeConstraints;
   property ControlState: TControlState;
   property ControlStyle: TControlStyle;
   property DockOrientation: TDockOrientation;
   property ExplicitLeft: Integer;
   property ExplicitTop: Integer;
   property ExplicitWidth: Integer;
   property ExplicitHeight: Integer;
   property Floating: Boolean;
   property FloatingDockSiteClass: TWinControlClass;
   property HostDockSite: TWinControl;
   property LRDockWidth: Integer;
   property ShowHint: Boolean;
   property TBDockHeight: Integer;
   property Touch: TTouchManager;
   property UndockHeight: Integer;
   property UndockWidth: Integer;
   property Visible: Boolean;
   property WindowProc: TWndMethod;
   property Parent: TWinControl;
   property StyleElements: TStyleElements;
   property OnGesture: TGestureEvent;
   property ComObject: IInterface;
   property ComponentCount: Integer;
   property ComponentIndex: Integer;
   property ComponentState: TComponentState;
   property ComponentStyle: TComponentStyle;
   property DesignInfo: Integer;
   property Owner: TComponent;
   property VCLComObject: Pointer;
   property Observers: TObservers;
  published
   property AccessibleName: string;
   property Action: TBasicAction;
   property Align: TAlign;
   property Alignment: TAlignment;
   property Anchors: TAnchors;
   property AnimationDuration: Cardinal;
   property AutoExpandDelay: Cardinal;
   property AutoScrollDelay: Cardinal;
   property AutoScrollInterval: TAutoScrollInterval;
   property Background: TPicture;
   property BackgroundOffsetX: Integer;
   property BackgroundOffsetY: Integer;
   property BiDiMode: TBiDiMode;
   property BevelEdges: TBevelEdges;
   property BevelInner: TBevelCut;
   property BevelOuter: TBevelCut;
   property BevelKind: TBevelKind;
   property BevelWidth: TBevelWidth;
   property BorderStyle: TBorderStyle;
   property BottomSpace: Cardinal;
   property ButtonFillMode: TVTButtonFillMode;
   property ButtonStyle: TVTButtonStyle;
   property BorderWidth: TBorderWidth;
   property ChangeDelay: Cardinal;
   property CheckImageKind: TCheckImageKind;
   property ClipboardFormats: TClipboardFormats;
   property Color: TColor;
   property Colors: TVTColors;
   property Constraints: TSizeConstraints;
   property Ctl3D: Boolean;
   property CustomCheckImages: TCustomImageList;
   property DefaultNodeHeight: Cardinal;
   property DefaultPasteMode: TVTNodeAttachMode;
   property DefaultText: WideString;
   property DragCursor: TCursor;
   property DragHeight: Integer;
   property DragKind: TDragKind;
   property DragImageKind: TVTDragImageKind;
   property DragMode: TDragMode;
   property DragOperations: TDragOperations;
   property DragType: TVTDragType;
   property DragWidth: Integer;
   property DrawSelectionMode: TVTDrawSelectionMode;
   property EditDelay: Cardinal;
   property Enabled: Boolean;
   property Font: TFont;
   property Header: TVTHeader;
   property HintAnimation: THintAnimationType;
   property HintMode: TVTHintMode;
   property HintTimeOut: Integer;
   property HotCursor: TCursor;
   property Images: TCustomImageList;
   property IncrementalSearch: TVTIncrementalSearch;
   property IncrementalSearchDirection: TVTSearchDirection;
   property IncrementalSearchStart: TVTSearchStart;
   property IncrementalSearchTimeout: Cardinal;
   property Indent: Cardinal;
   property LineMode: TVTLineMode;
   property LineStyle: TVTLineStyle;
   property Margin: Integer;
   property NodeAlignment: TVTNodeAlignment;
   property NodeDataSize: Integer;
   property ParentBiDiMode: Boolean;
   property ParentColor: Boolean;
   property ParentCtl3D: Boolean;
   property ParentFont: Boolean;
   property ParentShowHint: Boolean;
   property PopupMenu: TPopupMenu;
   property RootNodeCount: Cardinal;
   property ScrollBarOptions: TScrollBarOptions;
   property SelectionBlendFactor: Byte;
   property SelectionCurveRadius: Cardinal;
   property ShowHint: Boolean;
   property StateImages: TCustomImageList;
   property TabOrder: TTabOrder;
   property TabStop: Boolean;
   property TextMargin: Integer;
   property TreeOptions: TStringTreeOptions;
   property Visible: Boolean;
   property WantTabs: Boolean;
   property OnAdvancedHeaderDraw: TVTAdvancedHeaderPaintEvent;
   property OnAfterCellPaint: TVTAfterCellPaintEvent;
   property OnAfterItemErase: TVTAfterItemEraseEvent;
   property OnAfterItemPaint: TVTAfterItemPaintEvent;
   property OnAfterPaint: TVTPaintEvent;
   property OnBeforeCellPaint: TVTBeforeCellPaintEvent;
   property OnBeforeItemErase: TVTBeforeItemEraseEvent;
   property OnBeforeItemPaint: TVTBeforeItemPaintEvent;
   property OnBeforePaint: TVTPaintEvent;
   property OnChange: TVTChangeEvent;
   property OnChecked: TVTChangeEvent;
   property OnChecking: TVTCheckChangingEvent;
   property OnClick: TNotifyEvent;
   property OnCollapsed: TVTChangeEvent;
   property OnCollapsing: TVTChangingEvent;
   property OnColumnClick: TVTColumnClickEvent;
   property OnColumnDblClick: TVTColumnDblClickEvent;
   property OnColumnResize: TVTHeaderNotifyEvent;
   property OnCompareNodes: TVTCompareEvent;
   property OnContextPopup: TContextPopupEvent;
   property OnCreateDataObject: TVTCreateDataObjectEvent;
   property OnCreateDragManager: TVTCreateDragManagerEvent;
   property OnCreateEditor: TVTCreateEditorEvent;
   property OnDblClick: TNotifyEvent;
   property OnDragAllowed: TVTDragAllowedEvent;
   property OnDragOver: TVTDragOverEvent;
   property OnDragDrop: TVTDragDropEvent;
   property OnEditCancelled: TVTEditCancelEvent;
   property OnEdited: TVTEditChangeEvent;
   property OnEditing: TVTEditChangingEvent;
   property OnBeforeEndEditing: TVTEndEditingEvent;
   property OnAfterEndEditing: TVTEndEditingEvent;
   property OnEndDock: TEndDragEvent;
   property OnEndDrag: TEndDragEvent;
   property OnEnter: TNotifyEvent;
   property OnExit: TNotifyEvent;
   property OnExpanded: TVTChangeEvent;
   property OnExpanding: TVTChangingEvent;
   property OnFocusChanged: TVTFocusChangeEvent;
   property OnFocusChanging: TVTFocusChangingEvent;
   property OnFreeNode: TVTFreeNodeEvent;
   property OnGetCellIsEmpty: TVTGetCellIsEmptyEvent;
   property OnGetCursor: TVTGetCursorEvent;
   property OnGetHeaderCursor: TVTGetHeaderCursorEvent;
   property OnGetText: TVSTGetTextEvent;
   property OnPaintText: TVTPaintText;
   property OnGetHelpContext: TVTHelpContextEvent;
   property OnGetImageIndex: TVTGetImageEvent;
   property OnGetImageIndexEx: TVTGetImageExEvent;
   property OnGetHint: TVSTGetHintEvent;
   property OnGetLineStyle: TVTGetLineStyleEvent;
   property OnGetNodeDataSize: TVTGetNodeDataSizeEvent;
   property OnGetPopupMenu: TVTPopupEvent;
   property OnGetUserClipboardFormats: TVTGetUserClipboardFormatsEvent;
   property OnHeaderClick: TVTHeaderClickEvent;
   property OnHeaderDblClick: TVTHeaderClickEvent;
   property OnHeaderDragged: TVTHeaderDraggedEvent;
   property OnHeaderDraggedOut: TVTHeaderDraggedOutEvent;
   property OnHeaderDragging: TVTHeaderDraggingEvent;
   property OnHeaderDraw: TVTHeaderPaintEvent;
   property OnHeaderDrawQueryElements: TVTHeaderPaintQueryElementsEvent;
   property OnHeaderMouseDown: TVTHeaderMouseEvent;
   property OnHeaderMouseMove: TVTHeaderMouseMoveEvent;
   property OnHeaderMouseUp: TVTHeaderMouseEvent;
   property OnHotChange: TVTHotNodeChangeEvent;
   property OnIncrementalSearch: TVTIncrementalSearchEvent;
   property OnInitChildren: TVTInitChildrenEvent;
   property OnInitNode: TVTInitNodeEvent;
   property OnKeyAction: TVTKeyActionEvent;
   property OnKeyDown: TKeyEvent;
   property OnKeyPress: TKeyPressEvent;
   property OnKeyUp: TKeyEvent;
   property OnLoadNode: TVTSaveNodeEvent;
   property OnMeasureItem: TVTMeasureItemEvent;
   property OnMouseDown: TMouseEvent;
   property OnMouseMove: TMouseMoveEvent;
   property OnMouseUp: TMouseEvent;
   property OnMouseWheel: TMouseWheelEvent;
   property OnNewText: TVSTNewTextEvent;
   property OnNodeCopied: TVTNodeCopiedEvent;
   property OnNodeCopying: TVTNodeCopyingEvent;
   property OnNodeMoved: TVTNodeMovedEvent;
   property OnNodeMoving: TVTNodeMovingEvent;
   property OnPaintBackground: TVTBackgroundPaintEvent;
   property OnPopulatePopupMenu: TNotifyEvent;
   property OnRenderOLEData: TVTRenderOLEDataEvent;
   property OnResetNode: TVTChangeEvent;
   property OnResize: TNotifyEvent;
   property OnSaveNode: TVTSaveNodeEvent;
   property OnScroll: TVTScrollEvent;
   property OnShortenString: TVSTShortenStringEvent;
   property OnShowScrollbar: TVTScrollbarShowEvent;
   property OnStartDock: TStartDockEvent;
   property OnStartDrag: TStartDragEvent;
   property OnStateChange: TVTStateChangeEvent;
   property OnStructureChange: TVTStructureChangeEvent;
   property OnUpdating: TVTUpdatingEvent;
   property AlignWithMargins: Boolean;
   property Left: Integer;
   property Top: Integer;
   property Width: Integer;
   property Height: Integer;
   property Cursor: TCursor;
   property Hint: string;
   property HelpType: THelpType;
   property HelpKeyword: string;
   property HelpContext: THelpContext;
   property Margins: TMargins;
   property CustomHint: TCustomHint;
   property ParentCustomHint: Boolean;
   property Name: TComponentName;
   property Tag: NativeInt;
  end;
